/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import noppes.npcs.LogWriter;
import noppes.npcs.api.CommandNoppesBase;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.RoleCompanion;
import noppes.npcs.roles.RoleFollower;
import org.apache.commons.lang3.ArrayUtils;

public class CmdNPC
extends CommandNoppesBase {
    public EntityNPCInterface selectedNpc;

    @CommandNoppesBase.SubCommand(desc="Creates an NPC", usage="[name]", permission=2)
    public void create(MinecraftServer server, ICommandSender sender, String[] args) {
        World pw = sender.func_130014_f_();
        EntityCustomNpc npc = new EntityCustomNpc(pw);
        if (args.length > 0) {
            npc.display.setName(args[0]);
        }
        BlockPos pos = sender.func_180425_c();
        npc.func_70080_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 0.0f, 0.0f);
        npc.ais.setStartPos(pos);
        pw.func_72838_d((Entity)npc);
        npc.func_70606_j(npc.func_110138_aP());
    }

    @CommandNoppesBase.SubCommand(desc="Delete an NPC", permission=2)
    public void delete(MinecraftServer server, ICommandSender sender, String[] args) {
        this.selectedNpc.delete();
    }

    @Override
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args == null) {
            return;
        }
        String npcname = args[0].replace("%", " ");
        String command = args[1];
        args = Arrays.copyOfRange(args, 2, args.length);
        if (command.equalsIgnoreCase("create")) {
            args = (String[])ArrayUtils.add((Object[])args, (int)0, (Object)npcname);
            this.executeSub(server, sender, command, args);
            return;
        }
        List<EntityNPCInterface> list = this.getEntities(EntityNPCInterface.class, sender.func_130014_f_(), sender.func_180425_c(), 80);
        for (EntityNPCInterface npc : list) {
            String name = npc.display.getName().replace(" ", "_");
            if (!name.equalsIgnoreCase(npcname) || this.selectedNpc != null && !(this.selectedNpc.func_174818_b(sender.func_180425_c()) > npc.func_174818_b(sender.func_180425_c()))) continue;
            this.selectedNpc = npc;
        }
        if (this.selectedNpc == null) {
            throw new CommandException("Npc \"" + npcname + "\" was not found", new Object[0]);
        }
        this.executeSub(server, sender, command, args);
        this.selectedNpc = null;
    }

    @Override
    public String getDescription() {
        return "NPC operation";
    }

    public <T extends Entity> List<T> getEntities(Class<? extends T> cls, World world, BlockPos pos, int range) {
        List list = new ArrayList();
        try {
            list = world.func_72872_a(cls, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)).func_72314_b((double)range, (double)range, (double)range));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    @Override
    @Nonnull
    public String func_71517_b() {
        return "npc";
    }

    @Override
    public int func_82362_a() {
        return 4;
    }

    @Nonnull
    public List<String> func_184883_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender par1, @Nonnull String[] args, BlockPos pos) {
        if (args.length == 2) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"create", "home", "visible", "delete", "owner", "name"});
        }
        if (args.length == 3 && args[1].equalsIgnoreCase("owner")) {
            return CommandBase.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        return new ArrayList<String>();
    }

    @Override
    public String getUsage() {
        return "<name> <command>";
    }

    @CommandNoppesBase.SubCommand(desc="Set Home (respawn place)", usage="[x] [y] [z]", permission=2)
    public void home(MinecraftServer server, ICommandSender sender, String[] args) {
        BlockPos pos = sender.func_180425_c();
        if (args.length == 3) {
            try {
                pos = CommandBase.func_175757_a((ICommandSender)sender, (String[])args, (int)0, (boolean)false);
            }
            catch (NumberInvalidException e) {
                LogWriter.error((Object)e);
            }
        }
        this.selectedNpc.ais.setStartPos(pos);
    }

    @CommandNoppesBase.SubCommand(desc="Set NPC name", usage="[name]", permission=2)
    public void name(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length < 1) {
            return;
        }
        StringBuilder name = new StringBuilder(args[0]);
        for (int i = 1; i < args.length; ++i) {
            name.append(" ").append(args[i]);
        }
        if (!this.selectedNpc.display.getName().contentEquals(name)) {
            this.selectedNpc.display.setName(name.toString());
            this.selectedNpc.updateClient = true;
        }
    }

    @CommandNoppesBase.SubCommand(desc="Sets the owner of an follower/companion", usage="[player]", permission=2)
    public void owner(MinecraftServer server, ICommandSender sender, String[] args) {
        EntityPlayerMP player = null;
        if (args.length < 1) {
            if (this.selectedNpc.advanced.roleInterface instanceof RoleFollower) {
                player = ((RoleFollower)this.selectedNpc.advanced.roleInterface).owner;
            }
            if (this.selectedNpc.advanced.roleInterface instanceof RoleCompanion) {
                player = ((RoleCompanion)this.selectedNpc.advanced.roleInterface).owner;
            }
            if (player == null) {
                this.sendMessage(sender, "No owner", new Object[0]);
            } else {
                this.sendMessage(sender, "Owner is: " + player.func_70005_c_(), new Object[0]);
            }
        } else {
            try {
                player = CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
            if (player != null) {
                if (this.selectedNpc.advanced.roleInterface instanceof RoleFollower) {
                    ((RoleFollower)this.selectedNpc.advanced.roleInterface).setOwner((EntityPlayer)player);
                }
                if (this.selectedNpc.advanced.roleInterface instanceof RoleCompanion) {
                    ((RoleCompanion)this.selectedNpc.advanced.roleInterface).setOwner((EntityPlayer)player);
                }
            }
        }
    }

    @CommandNoppesBase.SubCommand(desc="Resets the npc", usage="[name]", permission=2)
    public void reset(MinecraftServer server, ICommandSender sender, String[] args) {
        this.selectedNpc.reset();
    }

    @Override
    public boolean runSubCommands() {
        return false;
    }

    @CommandNoppesBase.SubCommand(desc="Set NPC visibility", usage="[true/false/semi]", permission=2)
    public void visible(MinecraftServer server, ICommandSender sender, String[] args) {
        if (args.length < 1) {
            return;
        }
        boolean bo = args[0].equalsIgnoreCase("true");
        boolean semi = args[0].equalsIgnoreCase("semi");
        if (semi) {
            this.selectedNpc.display.setVisible(2);
        } else if (bo) {
            this.selectedNpc.display.setVisible(0);
        } else {
            this.selectedNpc.display.setVisible(1);
        }
    }
}

